package com.elc.broadcastinterface;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.NotificationManager;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.media.AudioManager;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.provider.Settings;
import android.renderscript.ScriptIntrinsicBlur;
import android.text.Editable;
import android.text.InputType;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.TextView;
import android.widget.Toast;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import android.app.AlertDialog;
import android.app.AlertDialog.Builder;

public class MainActivity extends Activity {
    private ArrayList<ItemText> mData = null;
    private int eth_int = 0;
    private int wifi_int = 0;
    private int bar_int = 0;

    private final static String DEFAULT_IP="192.168.100.125";
    private final static String DEFAULT_SUB_MASK="255.255.255.0";
    private final static String DEFAULT_GATWAY="192.168.100.1";
    private final static String DEFAULT_DNS1="8.8.8.8";
    private final static String DEFAULT_DNS2="8.8.4.4";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        GridView grid_text = findViewById(R.id.grid);
        mData = new ArrayList<ItemText>();
        String[] testText = {getResources().getString(R.string.reboot), getResources().getString(R.string.shutdown), getResources().getString(R.string.sleep),
                getResources().getString(R.string.wakeup), getResources().getString(R.string.rotation), getResources().getString(R.string.rotation2),
                getResources().getString(R.string.rotation3), getResources().getString(R.string.install), getResources().getString(R.string.stopapp),
                getResources().getString(R.string.setpower), getResources().getString(R.string.systime), getResources().getString(R.string.screencap),
                getResources().getString(R.string.hidesysbar), getResources().getString(R.string.backlight), getResources().getString(R.string.audio),
                getResources().getString(R.string.audio2), getResources().getString(R.string.silence), getResources().getString(R.string.reset),
                getResources().getString(R.string.eth),getResources().getString(R.string.ethStatic),getResources().getString(R.string.ethDHCP),
                getResources().getString(R.string.ethProxy),getResources().getString(R.string.wifiCom)};
        for (String s : testText) mData.add(new ItemText(s));

        final EditText ipEditView=findViewById(R.id.ip);
        ipEditView.setText(DEFAULT_IP);
        final EditText subMaskEditView=findViewById(R.id.sub_mask);
        subMaskEditView.setText(DEFAULT_SUB_MASK);
        final EditText getwayEditView=findViewById(R.id.gatway);
        getwayEditView.setText(DEFAULT_GATWAY);
        final EditText dns1EditView=findViewById(R.id.dns1);
        dns1EditView.setText(DEFAULT_DNS1);
        final EditText dns2EditView=findViewById(R.id.dns2);
        dns2EditView.setText(DEFAULT_DNS2);

        BaseAdapter mAdapter = new InterfaceAdapter<ItemText>(mData, R.layout.item_grid_text) {
            @Override
            public void bindView(ViewHolder holder, ItemText obj) {
                holder.setText(R.id.txt, obj.getiName());
            }
        };

        grid_text.setAdapter(mAdapter);

        grid_text.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                //Toast.makeText(MainActivity.this, "你点击了~" + position + "~项", Toast.LENGTH_SHORT).show();
                android.util.Log.i("MainActivity","position:"+position);
                switch (position) {
                    case 0:
                        sendBroadcast(new Intent("android.intent.action.reboot"));    //重启
                        break;
                    case 1:
                        sendBroadcast(new Intent("android.intent.action.shutdown"));
                        break;
                    case 2:
                        new Thread(new Runnable() {
                            @Override
                            public void run() {
                                try {
                                    sendBroadcast(new Intent("android.intent.action.gotosleep"));
                                    Thread.sleep(5000L);
                                    sendBroadcast(new Intent("android.intent.action.exitsleep"));
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }).start();
                        break;
                    case 3:
                        sendBroadcast(new Intent("android.intent.action.exitsleep"));
                        break;
                    case 4:
                        Settings.System.putInt(context.getContentResolver().Settings.System.ACCELEROMETER_ROTATION, 0);
                        //sendBroadcast(new Intent("android.intent.rotation_90"));
                        break;
                    case 5:
                        sendBroadcast(new Intent("android.intent.rotation_180"));
                        break;
                    case 6:
                        sendBroadcast(new Intent("android.intent.rotation_0"));
                        break;
                    case 7:
                        SetDiaClick("com.android.xxx.installapp", "apppath", "路径", "/sdcard/xxx.apk", -1);
                        break;
                    case 8:
                        SetDiaClick("com.android.xxx.killapp", "packagename", "包名", "com.elc.broadcastinterface", -1);//关闭Apk
                        break;
                    case 9:
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
                        final String dateString = dateFormat.format(Calendar.getInstance().getTime());
                        adbcommand("system/xbin/test "+getDateStr(dateString,1)+" "+getDateStr(dateString,2)+" enable");
                        //Intent intent = new Intent();
                        //intent.setAction("android.intent.action.setpoweronoff");
                        //int[] timeonArray = {2014, 10, 1, 8, 30};
                        //int[] timeoffArray = {2014, 9, 1, 8, 30};
                        //intent.putExtra("timeon", timeonArray);
                        //intent.putExtra("timeoff", timeoffArray);
                        //intent.putExtra("enable", true);
                        //sendBroadcast(intent);
                        break;
                    case 10:
                        SetDiaClick("com.android.xxx.setsystemtime", "time", "时间戳", "121424121", -1);
                        break;
                    case 11:
                        sendBroadcast(new Intent("android.intent.action.screencap"));
                        break;
                    case 12:
                        if (bar_int == 0){
                            sendBroadcast(new Intent("com.xxx.action.HIDE_STATUS_BAR").putExtra("hide", false));
                            Toast.makeText(MainActivity.this,"显示状态栏",Toast.LENGTH_SHORT).show();
                            bar_int = 1;
                        } else if (bar_int == 1){
                            sendBroadcast(new Intent("com.xxx.action.HIDE_STATUS_BAR").putExtra("hide", true));
                            Toast.makeText(MainActivity.this,"隐藏状态栏",Toast.LENGTH_SHORT).show();
                            bar_int = 0;
                        }
                        break;
                    case 13:
                        SetDiaClick("com.xxx.action.BACK_LIGHT_BRIGHTNESS", "brightness", "亮度", "50", 50);
                        break;
                    case 14:
                        AudioManager audio = (AudioManager) getSystemService(Service.AUDIO_SERVICE);
                        audio.adjustStreamVolume(AudioManager.STREAM_MUSIC,AudioManager.ADJUST_RAISE, AudioManager.FLAG_SHOW_UI);
                        break;
                    case 15:
                        AudioManager audio2 = (AudioManager)getSystemService(Service.AUDIO_SERVICE);
                        audio2.adjustStreamVolume(AudioManager.STREAM_MUSIC,AudioManager.ADJUST_LOWER,AudioManager.FLAG_SHOW_UI);
                        break;
                    case 16:
                        AudioManager audio3 = (AudioManager)getSystemService(Service.AUDIO_SERVICE);
                        NotificationManager notificationManager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
                        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N && !notificationManager.isNotificationPolicyAccessGranted()) {
                            startActivity(new Intent(Settings.ACTION_NOTIFICATION_POLICY_ACCESS_SETTINGS));
                        }else{
                            audio3.setRingerMode(AudioManager.RINGER_MODE_SILENT);
                        }
                        break;
                    case 17:
                        sendBroadcast(new Intent("android.intent.action.resetsystem"));
                        break;
                    case 18:
                        Intent intent =new Intent();
                        intent.setAction("com.android.intent.setEthEnabled");
                        if (eth_int == 0){
                            intent.putExtra("enable",true);
                            eth_int = 1;
                            Toast.makeText(MainActivity.this,"以太网开",Toast.LENGTH_SHORT).show();
                        }else if (eth_int == 1){
                            intent.putExtra("enable",false);
                            Toast.makeText(MainActivity.this,"以太网关",Toast.LENGTH_SHORT).show();
                            eth_int = 0;
                        }
                        sendBroadcast(intent);

                        break;
                    case 19:
                        String ip=ipEditView.getText().toString();
                        String submask=subMaskEditView.getText().toString();
                        String gatway=getwayEditView.getText().toString();
                        String dns1=dns1EditView.getText().toString();
                        String dns2=dns2EditView.getText().toString();
                        if(TextUtils.isEmpty(ip)){
                            ip=DEFAULT_IP;
                        }
                        if(TextUtils.isEmpty(submask)){
                            submask=DEFAULT_SUB_MASK;
                        }
                        if(TextUtils.isEmpty(gatway)){
                            gatway=DEFAULT_GATWAY;
                        }
                        if(TextUtils.isEmpty(dns1)){
                            dns1=DEFAULT_DNS1;
                        }
                        if(TextUtils.isEmpty(dns2)){
                            dns2=DEFAULT_DNS2;
                        }


                        Intent intent_et = new Intent();
                        intent_et.setAction("com.android.intent.setEthIpStatic");
                        intent_et.putExtra("ipAddress",ip);
                        intent_et.putExtra("subnetMask",submask);
                        intent_et.putExtra("gateway",gatway);
                        intent_et.putExtra("dns1",dns1);
                        intent_et.putExtra("dns2",dns2);
                        android.util.Log.i("MainActivity","19 ip:"+ip+",submask:"+submask+",gatway:"+gatway+",dns1:"+dns1+",dns2:"+dns2);
                        sendBroadcast(intent_et);
                        break;
                    case 20:
                        Intent intent_etd = new Intent();
                        intent_etd.setAction("com.android.intent.setEthIpDhcp");
                        sendBroadcast(intent_etd);
                        break;
                    case 21:
                        Intent intent_etp = new Intent();
                        intent_etp.setAction("com.android.intent.setEthProxyManual");
                        intent_etp.putExtra("Hostname","www.baidu.com");
                        intent_etp.putExtra("port","8080");
                        intent_etp.putExtra("bypassProxyFor","123.com");
                        sendBroadcast(intent_etp);
                        break;
                    case 22:
                        Intent intents = new Intent();
                        intents.setAction("com.android.intent.connectWifi");
                        intents.putExtra("wifi_ssid","HiWiFi_68D3A8");
                        intents.putExtra("wifi_password","elc123456");
                        if (wifi_int == 0){
                            intents.putExtra("ipMode",1);//静态IP 动态IP
                            intents.putExtra("proxyMode",1);//静态代理  动态代理  ；不设置即无
                            Toast.makeText(MainActivity.this,"WIFI 静态IP，手动代理",Toast.LENGTH_SHORT).show();
                            wifi_int = 1;
                        } else if (wifi_int == 1){
                            intents.putExtra("ipMode",0);//静态IP 动态IP
                            intents.putExtra("proxyMode",2);//静态代理  动态代理  ；不设置即无
                            Toast.makeText(MainActivity.this,"WIFI 动态IP，自动代理",Toast.LENGTH_SHORT).show();
                            wifi_int = 0;
                        }

                        String ip1=ipEditView.getText().toString();
                        String submask1=subMaskEditView.getText().toString();
                        String gatway1=getwayEditView.getText().toString();
                        String dns11=dns1EditView.getText().toString();
                        String dns21=dns2EditView.getText().toString();
                        if(TextUtils.isEmpty(ip1)){
                            ip1=DEFAULT_IP;
                        }
                        if(TextUtils.isEmpty(submask1)){
                            submask1=DEFAULT_SUB_MASK;
                        }
                        if(TextUtils.isEmpty(gatway1)){
                            gatway1=DEFAULT_GATWAY;
                        }
                        if(TextUtils.isEmpty(dns11)){
                            dns11=DEFAULT_DNS1;
                        }
                        if(TextUtils.isEmpty(dns21)){
                            dns21=DEFAULT_DNS2;
                        }

                        intents.putExtra("staticIpAddress",ip1);
                        intents.putExtra("staticIpPrefixLength",submask1);
                        intents.putExtra("staticIpGateway",gatway1);
                        intents.putExtra("staticIpDns1",dns11);
                        intents.putExtra("staticIpDns2",dns21);
                        intents.putExtra("manualProxyHostname","www.baidu.com"); //proxyMode 为1时设置
                        intents.putExtra("manualProxyPort","8080");//proxyMode 为1时设置
                        intents.putExtra("manualProxyBypassProxyFor","123.com");
                        intents.putExtra("autoProxyPacUrl","www.baidu.com"); //proxyMode 为2时设置
                        sendBroadcast(intents);
                        break;
                }
            }
        });
    }

    private void SetDiaClick(final String broadcast, final String extra, final String title, final String hint, final int bri) {
        Builder passWord = new AlertDialog.Builder(this);
        final EditText editText = new EditText(this);
        editText.setText(hint);
        editText.setImeOptions(EditorInfo.IME_ACTION_DONE);
        editText.setInputType(InputType.TYPE_CLASS_TEXT);
        editText.setLongClickable(false);
        passWord.setTitle(title);
        passWord.setView(editText);
        passWord.setCancelable(false);
        passWord.setPositiveButton("OK", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                // TODO Auto-generated method stub
                if (bri != -1) {
                    int inputntp = Integer.parseInt(editText.getText().toString().trim());
                    sendBroadcast(new Intent(broadcast).putExtra(extra, inputntp));
                } else {
                    String inputntp = editText.getText().toString().trim();
                    Log.d("Jessica", "||" + inputntp);
                    sendBroadcast(new Intent(broadcast).putExtra(extra, inputntp));
                }
            }
        });
        passWord.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
            }
        });
        passWord.create().show();
    }

    public static String getDateStr(String day, int Num) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
        Date nowDate = null;
        try {
            nowDate = df.parse(day);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        Date newDate2 = new Date(nowDate.getTime() + (long) Num * 60 * 1000);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmm");
        String dateOk = simpleDateFormat.format(newDate2);
        return dateOk;
    }

    public String adbcommand(String command) {
        Process process = null;
        DataOutputStream os = null;
        String excresult = "";
        try {
            process = Runtime.getRuntime().exec("su");
            os = new DataOutputStream(process.getOutputStream());
            os.writeBytes(command + "\n");
            os.writeBytes("exit\n");
            os.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(
                    process.getInputStream()));
            StringBuffer stringBuffer = new StringBuffer();
            String line = null;
            while ((line = in.readLine()) != null) {
                stringBuffer.append(line + " ");
            }
            excresult = stringBuffer.toString();
            in.close();
            process.destroy();
        } catch (Exception e) {
            e.printStackTrace();
        }finally {
        }
        return excresult;
    }

    @Override
    protected void onRestart() {
        super.onRestart();
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }
}
